#pragma once

#include "stdafx.h"

/// <summary>
/// Class that stores information of a single ISO-TP mapping.
/// </summary>
class MappingStatus {

public:

	MappingStatus(
		UINT32 canId,
		UINT32 canIdResponse,
		TPCANTPIdType canIdType,
		TPCANTPFormatType formatType,
		TPCANTPMessageType msgType,
		TPCANTPAddressingType targetType,
		byte sourceAddr,
		byte targetAddr,
		byte remoteAddr);

public_member:
	UINT32 m_canId;
	UINT32 m_canIdResponse;
	TPCANTPIdType m_canIdType;
	TPCANTPFormatType m_formatType;
	TPCANTPMessageType m_msgType;
	byte m_sourceAddr;
	byte m_targetAddr;
	TPCANTPAddressingType m_targetType;
	byte m_remoteAddr;

public_method:
	MappingStatus Clone();
	TPCANTPIdType GetCanIdType();
	bool IsAutomatic();
	CString Name();
	CString CanId();
	CString CanIdResponse();
	CString CanIdType();
	CString MsgType();
	CString FormatType();
	CString TargetType();
	CString SourceAddress();
	CString TargetAddress();
	CString RemoteAddress();
};